//EX 1. Program Title:Determine Diode current for input DC voltage and temperature.///
//environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
mprintf('\n Required Data for ID=Is*(e^(VD/n*VT)-1) is:'); 
mprintf('\n'); 
VD=input('Enter the value of input DC Voltage in volts: ');//Note:Input DC voltage is int range of 0 to 5
T=input('Enter the value of temperature in degree Celsius : ');//Note: temperature is in the degree celsius 
p=273;
TK=p+T;
k=1.38e-23        //Joule per Kelvin     Boltzmann's Constant
k1=k*1e21         //zepto Joule per kelvin
q= 1.6e-19        // columb              electron charge
q1=q*1e18          // atto coulomb        electron charge
Is=10e-12         // Amperes               Reverse saturation current
Is1=Is*1e9//nano amperes
n=1  ; // Ideality factor
mprintf('\n. \***************************************************\');                  
mprintf('\n Temperature                      TK:%2d K',TK);
mprintf('\n Ideality factor                  n:%2d ',n);
mprintf('\n Reverse saturation Current       Is:%.3f nA',Is1);
mprintf('\n Boltzmanns Constant..            k:%.5f zJ/K',k1);
mprintf('\n Electron charge..                q:%.2f aC',q1);
mprintf('\n Forward bias voltage             VD:%.2f V',VD);
mprintf('\n. \***************************************************\');
////////////////////////////////////////
mprintf('\n Diode Current              ID=Is(e^x-1)');
mprintf('\n Where..                    x=VD/(n*VT)');  
mprintf('\n Thermal Voltage            VT=(k*TK)/q'); 
mprintf('\n. \****************Solution****************************\');
[ID1,x,VT]=diode_current2(VD,TK)//Function of diode current
mprintf('\n Thermal Voltage.............VT = %f V \n',VT);     // Theramal Voltage Display
mprintf('\n');// Next line
mprintf(' ..............................x=%f \n',x);                          
mprintf('\n');                        // Next line
mprintf('Diode Current................ID= %f mA \n',ID1);//Diode Current Display
mprintf('\n. \****************************************************\');


//Output

// Required Data for ID=Is*(e^(VD/n*VT)-1) is:
//Enter the value of input DC Voltage in volts: .45
//Enter the value of temperature in degree Celsius : 27

//. ***************************************************
// Temperature                      TK:300 K
 //Ideality factor                  n: 1 
 //Reverse saturation Current       Is:0.010 nA
 //Boltzmanns Constant..            k:0.01380 zJ/K
 //Electron charge..                q:0.16 aC
// Forward bias voltage             VD:0.45 V
//. ***************************************************
// Diode Current              ID=Is(e^x-1)
// Where..                    x=VD/(n*VT)
// Thermal Voltage            VT=(k*TK)/q
//. ****************Solution****************************
// Thermal Voltage.............VT = 0.025875 V 

 //..............................x=17.391304 

//Diode Current................ID= 0.000357 mA 

//. **************************************************** 